/// Appuyer sur espace une 1ère fois pour lancer l'enregistrement de la trajectoire
/// Appuyer sur espace une 2ème fois pour terminer l'enregistrement de la trajectoire
/// Echap pour quitter et sauver la trajectoire dans le fichier capture.txt

/// Le fichier capture.txt contiendra une unique ligne commençant par le nombre de coordonnées
/// suivi des coordonnées x y consécutives. Copier coller cette ligne dans un fichier trajectoires.txt
/// pour constituer une bibliothèque de trajectoires. Il est préférable d'utiliser un éditeur technique
/// comme Notepad++ pour manipuler des lignes de données longues (désactiver Word wrap dans View)

/// Pour "customiser" voir les paramètres en constantes (ligne 20 à 23) et début du main (lignes 53 à 64)
/// Il est bien sûr possible de généraliser et d'enregistrer d'autres actions (tirer ...) : ajouter des champs à x et y

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <math.h>


/// PARAMETRES
#define MARGE_X 50
#define MARGE_Y 50
#define TERRAIN_JEU_LARGEUR 800
#define TERRAIN_JEU_HAUTEUR 600

// Trajectoire de 200 secondes max (avec rest de 20)
#define MAX_COORD 10000

// Déclaration "en avant" (forward declaration)
typedef struct point t_point;
typedef struct trajectoire t_trajectoire;

// Créer un objet de type t_trajectoire avec stockage pour maxc points
t_trajectoire * allouer_trajectoire(int maxc);

// Ajouter un nouveau point à la trajectoire
void ajouter_a_trajectoire(t_trajectoire *t, int x, int y);

// Sauve les points enregistrés dans capture.txt
void sauver_trajectoire(t_trajectoire *t);

// Affiche les points enregistrés jusqu'à maintenant
void afficher_trajectoire(BITMAP *page, t_trajectoire *t);

// Lancer allegro et le mode graphique
void lancer_allegro();


int main()
{
    /// PARAMETRES

    /// Enregistrement direct en position (1 pour oui)
    int direct = 0;

    /// Vitesse absolue en nombre de pixels par tour de boucle
    /// Paramètre utilisé pour direct=0
    float vitesse = 10;

    /// Valeur du rest de votre boucle de jeu
    int valrest = 20;

    /// Ralentissement (par rapport au playback prévu)
    /// Mettre à 1 pour être en temps réel
    int ralentissement = 5;


    t_trajectoire *traj;
    BITMAP *page;
    float posx, posy;
    float depx, depy, norme;

    int spp, spn = 0;
    int record = 0;


    lancer_allegro();
    page = create_bitmap(SCREEN_W, SCREEN_H);


    traj = allouer_trajectoire(MAX_COORD);
    posx = SCREEN_W/2;
    posy = SCREEN_H/2;

    while (!key[KEY_ESC])
    {
        clear_bitmap(page);

        rect(page, MARGE_X, MARGE_Y, SCREEN_W-MARGE_X, SCREEN_H-MARGE_Y, makecol(255,255,255));


        /// Déplacement en direct (irrégulier en vitesse)
        if (direct)
        {
            posx = mouse_x;
            posy = mouse_y;
        }

        /// Déplacement avec régulation de vitesse
        else
        {
            depx = mouse_x - posx;
            depy = mouse_y - posy;
            norme = sqrt(depx*depx + depy*depy);

            // Cas cible (souris) immobile et mobile dessus : norme vaut 0 !
            if (norme<=vitesse)
            {
                depx = 0;
                depy = 0;
                posx = mouse_x;
                posy = mouse_y;
            }
            else
            {
                depx = vitesse*depx/norme;
                depy = vitesse*depy/norme;
                posx = posx+depx;
                posy = posy+depy;
            }
        }

        // Bascule mode enregistrement par appui barre espace
        spp = spn;
        spn = key[KEY_SPACE];
        if ( !spp && spn )
            record = !record;

        // Gestion mode enregistrement
        if (record)
        {
            ajouter_a_trajectoire(traj, posx-MARGE_X, posy-MARGE_Y);
            circlefill(page, posx, posy, 30, makecol(255,0,0));
        }
        else
            circlefill(page, posx, posy, 30, makecol(0,255,0));

        afficher_trajectoire(page, traj);

        blit(page, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

        rest(ralentissement*valrest);
    }

    sauver_trajectoire(traj);


    return 0;
}
END_OF_MAIN();



// Ces structures ont déjà été typedefées
struct point {
    int x, y;
};

struct trajectoire {
    int npoints;
    t_point * points;
};


// Créer un objet de type t_trajectoire avec stockage pour maxc points
t_trajectoire * allouer_trajectoire(int maxc)
{
    t_trajectoire * t;

    t = (t_trajectoire *)malloc(1*sizeof(t_trajectoire));
    t->points = (t_point *)malloc(maxc*sizeof(t_point));
    t->npoints = 0;

    return t;
}

// Ajouter un nouveau point à la trajectoire
void ajouter_a_trajectoire(t_trajectoire *t, int x, int y)
{
    int i;

    if (t->npoints>=MAX_COORD)
    {
        printf("Trajectoire pleine !\n");
        return;
    }

    i = t->npoints;
    t->points[i].x = x;
    t->points[i].y = y;
    t->npoints++;
}

// Sauve les points enregistrés dans capture.txt
void sauver_trajectoire(t_trajectoire *t)
{
    int i;
    FILE *fp;

    fp = fopen("capture.txt", "w");
    if (!fp)
    {
        printf("Pas pu sauver capture.txt !\n");
        return;
    }

    fprintf(fp,"%d ", t->npoints );

    for (i=0; i<t->npoints; i++)
        fprintf(fp,"%d %d ", t->points[i].x, t->points[i].y );

    fprintf(fp,"\n");

    fclose(fp);

    printf("Sauve capture.txt OK !\n");
}

// Affiche les points enregistrés jusqu'à maintenant
void afficher_trajectoire(BITMAP *page, t_trajectoire *t)
{
    int i;

    for (i=0; i<t->npoints; i++)
        circlefill(page, t->points[i].x+MARGE_X, t->points[i].y+MARGE_Y, 4, makecol(100, 100, 255) );
}


// Lancer allegro et le mode graphique
void lancer_allegro()
{
    allegro_init();
    install_keyboard();
    install_mouse();

    set_color_depth(desktop_color_depth());
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,
                     TERRAIN_JEU_LARGEUR+2*MARGE_X,
                     TERRAIN_JEU_HAUTEUR+2*MARGE_Y,0,0)!=0)
    {
        allegro_message("prb gfx mode");
        allegro_exit();
        exit(EXIT_FAILURE);
    }

    show_mouse(screen);
}
